/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.infernomobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.api.IGroupWater;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIStayByWater;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityKhalk
extends EntityCreatureTameable
implements IMob,
IGroupFire,
IGroupHeavy {
    public boolean khalkLavaDeath = true;

    public EntityKhalk(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 5;
        this.experience = 10;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.isLavaCreature = true;
        this.hasAttackSound = true;
        this.canGrow = true;
        this.babySpawnChance = 0.01;
        this.khalkLavaDeath = ConfigBase.getConfig(this.group, "general").getBool("Features", "Khalk Lava Death", this.khalkLavaDeath, "Set to false to disable Khalks from turning into a pile of lava on death.");
        this.setWidth = 4.5f;
        this.setHeight = 3.5f;
        this.solidCollision = true;
        this.setupMob();
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(20));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIStayByWater(this).setSpeed(1.25));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupIce.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupWater.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySnowman.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPlant.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 40.0);
        baseAttributes.put("movementSpeed", 0.2);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151044_h), 1.0f).setMaxAmount(32));
        this.drops.add(new DropRate(new ItemStack(Items.field_151064_bs), 0.75f).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Items.field_151065_br), 0.5f).setMaxAmount(8));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(6.0f, 0.1, (Entity)this.func_70638_az());
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.lavaContact()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150353_l) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_130014_f_().func_180495_p(pos).func_177230_c() == Blocks.field_150356_k) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)waterWeight;
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.lavaContact()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        target.func_70015_d(this.getEffectDuration(5) / 20);
        return true;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing") && this.khalkLavaDeath && !this.isTamed()) {
            int lavaWidth = (int)Math.floor(this.field_70130_N) - 1;
            int lavaHeight = (int)Math.floor(this.field_70131_O) - 1;
            for (int x = (int)this.field_70165_t - lavaWidth; x <= (int)this.field_70165_t + lavaWidth; ++x) {
                for (int y = (int)this.field_70163_u; y <= (int)this.field_70163_u + lavaHeight; ++y) {
                    for (int z = (int)this.field_70161_v - lavaWidth; z <= (int)this.field_70161_v + lavaWidth; ++z) {
                        Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150350_a) continue;
                        IBlockState blockState = Blocks.field_150356_k.func_176203_a(11);
                        if (x == (int)this.field_70165_t && y == (int)this.field_70163_u && z == (int)this.field_70161_v) {
                            blockState = Blocks.field_150356_k.func_176203_a(12);
                        }
                        this.func_130014_f_().func_180501_a(new BlockPos(x, y, z), blockState, 3);
                    }
                }
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (ObjectManager.getPotionEffect("Penetration") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("Penetration")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean canBreatheAboveWater() {
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public void applyDropEffects(EntityItemCustom entityitem) {
        entityitem.setCanBurn(false);
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityKhalk(this.func_130014_f_());
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

